from visual import *

class Spin:   
    def __init__(self):
        self.vector = arrow(visible=0)
        self.torqueVector = arrow(visible=0)
        self.position = vector()
        self.point = sphere(visible=0)
        self.torqueScale = 5.0

        self.tvVectors = 0
        self.tvTorqueVectors = 0
        self.tvPoints = 0

    def setArrow(self, arrowPos, color, width):
        self.vector.pos = arrowPos
        self.vector.color = color
        self.vector.shaftWidth = width

    def setPoint(self, color, radius):
        self.point.color = color
        self.point.radius = radius

    def setTorqueArrow(self, arrowPos, color, width):
        self.torqueVector.pos = arrowPos
        self.torqueVector.color = color
        self.torqueVector.shaftWidth = width

    def updateVectorPos(self, pos):
        self.vector.pos = pos

    def updateVectorAxis(self, axis):
        self.vector.axis = axis

    def updateTorqueVectorPos(self, pos):
        self.torqueVector.pos = pos

    def updateTorqueVectorAxis(self, axis):
        self.torqueVector.axis = axis/self.torqueScale

    def updatePointPos(self, pos):
        self.point.pos = pos
        
    def updatePointColor(self, color):
        self.point.color = color

    def getVectorPos(self):
        return self.vector.pos
    
    def getVectorAxis(self):
        return self.vector.axis
        
    def toggleVectorVisibility(self):
        self.tvVectors = (self.tvVectors+1)%2
        self.vector.visible = self.tvVectors

    def toggleTorqueVectorVisibility(self):
        self.tvTorqueVectors = (self.tvTorqueVectors+1)%2
        self.torqueVector.visible = self.tvTorqueVectors

    def togglePointVisibility(self):
        self.tvPoints = (self.tvPoints+1)%2
        self.point.visible = self.tvPoints



        
